package com.ejie.ab04b.model;

import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import java.util.Date;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

/**
 * ClaseCentroTrabajo generated by UDA, 27-dic-2016 12:43:15.
 * 
 * @author UDA
 */

public class ClaseCentroTrabajo implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private String clasctr072;
	private String desclasEu072;
	private String desclasEs072;
	private Date fecbaj072;
	
	// Añadidos filtro
	private Date fecbajaDesde;
	private Date fecbajaHasta;

	/**
	 * Method 'ClaseCentroTrabajo'.
	 */
	public ClaseCentroTrabajo() {
	}

	/**
	 * Method 'ClaseCentroTrabajo'.
	 * 
	 *  clasctr072
	 *            String
	 *
	 * @param clasctr072 the clasctr 072
	 */
	public ClaseCentroTrabajo(String clasctr072) {

		this.clasctr072 = clasctr072;
	}

	/**
	 * Method 'ClaseCentroTrabajo'.
	 * 
	 *  clasctr072
	 *            String
	 *  desclasEu072
	 *            String
	 *  desclasEs072
	 *            String
	 *  fecbaj072
	 *            Date
	 *
	 * @param clasctr072 the clasctr 072
	 * @param desclasEu072 the desclas eu 072
	 * @param desclasEs072 the desclas es 072
	 * @param fecbaj072 the fecbaj 072
	 */
	public ClaseCentroTrabajo(String clasctr072, String desclasEu072, String desclasEs072, Date fecbaj072) {

		this.clasctr072 = clasctr072;
		this.desclasEu072 = desclasEu072;
		this.desclasEs072 = desclasEs072;
		this.fecbaj072 = fecbaj072;
	}

	/**
	 * Method 'getClasctr072'.
	 * 
	 *  String
	 *
	 * @return the clasctr 072
	 */

	public String getClasctr072() {
		return this.clasctr072;
	}

	/**
	 * Method 'setClasctr072'.
	 * 
	 *  clasctr072            String
	 *
	 * @param clasctr072 the new clasctr 072
	 */

	public void setClasctr072(String clasctr072) {
		this.clasctr072 = clasctr072;
	}

	/**
	 * Method 'getDesclasEu072'.
	 * 
	 *  String
	 *
	 * @return the desclas eu 072
	 */

	public String getDesclasEu072() {
		return this.desclasEu072;
	}

	/**
	 * Method 'setDesclasEu072'.
	 * 
	 *  desclasEu072            String
	 *
	 * @param desclasEu072 the new desclas eu 072
	 */

	public void setDesclasEu072(String desclasEu072) {
		this.desclasEu072 = desclasEu072;
	}

	/**
	 * Method 'getDesclasEs072'.
	 * 
	 *  String
	 *
	 * @return the desclas es 072
	 */

	public String getDesclasEs072() {
		return this.desclasEs072;
	}

	/**
	 * Method 'setDesclasEs072'.
	 * 
	 *  desclasEs072            String
	 *
	 * @param desclasEs072 the new desclas es 072
	 */

	public void setDesclasEs072(String desclasEs072) {
		this.desclasEs072 = desclasEs072;
	}

	/**
	 * Method 'getFecbaj072'.
	 * 
	 *  Date
	 *
	 * @return the fecbaj 072
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecbaj072() {
		return this.fecbaj072;
	}

	/**
	 * Method 'setFecbaj072'.
	 * 
	 *  fecbaj072            Date
	 *
	 * @param fecbaj072 the new fecbaj 072
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecbaj072(Date fecbaj072) {
		this.fecbaj072 = fecbaj072;
	}
	
	/**
	 * Method 'getFecbajaDesde'.
	 * 
	 *  Date
	 *
	 * @return the fecbaja desde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecbajaDesde() {
		return this.fecbajaDesde;
	}
	
	/**
	 * Method 'setFecbajaDesde'.
	 * 
	 *  fecbajaDesde
	 *            Date
	 *
	 * @param fecbajaDesde the new fecbaja desde
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecbajaDesde(Date fecbajaDesde) {
		this.fecbajaDesde = fecbajaDesde;
	}

	/**
	 * Gets the fecbaja desde str.
	 * 
	 *  String
	 *
	 * @return the fecbaja desde str
	 */
	public String getFecbajaDesdeStr() {
		return Utilities.getInstance().formatearDateIdioma(this.fecbajaDesde);
	}

	/**
	 * Method 'setFecbajaDesde'.
	 * 
	 *  fecbajaDesde
	 *            Date
	 *
	 * @param fecbajaDesde the new fecbaja desde str
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecbajaDesdeStr(Date fecbajaDesde) {
		this.fecbajaDesde = fecbajaDesde;
	}

	/**
	 * Method 'getFecbajaHasta'.
	 * 
	 *  Date
	 *
	 * @return the fecbaja hasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFecbajaHasta() {
		return this.fecbajaHasta;
	}

	/**
	 * Method 'setFecbajaHasta'.
	 * 
	 *  fecbajaHasta
	 *            Date
	 *
	 * @param fecbajaHasta the new fecbaja hasta
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecbajaHasta(Date fecbajaHasta) {
		this.fecbajaHasta = fecbajaHasta;
	}

	/**
	 * Gets the fecbaja hasta str.
	 * 
	 *  String
	 *
	 * @return the fecbaja hasta str
	 */
	public String getFecbajaHastaStr() {
		return Utilities.getInstance().formatearDateIdioma(this.fecbajaHasta);
	}

	/**
	 * Method 'setFecbajaHasta'.
	 * 
	 *  fecbajaHasta
	 *            Date
	 *
	 * @param fecbajaHasta the new fecbaja hasta str
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFecbajaHastaStr(Date fecbajaHasta) {
		this.fecbajaHasta = fecbajaHasta;
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		// Clave compuesta

		result.append("[ clasctr072: ").append(this.clasctr072).append(" ]");

		result.append(", [ desclasEu072: ").append(this.desclasEu072).append(" ]");

		result.append(", [ desclasEs072: ").append(this.desclasEs072).append(" ]");

		result.append(", [ fecbaj072: ").append(this.fecbaj072).append(" ]");
		result.append("}");
		return result.toString();
	}

}
